unit PrinPr;
{ This Unit shows how to use buttons and strings in the statusbar
  and how to use the function print_xywh(Canvas, ...

  I Use the wpFastPrint Method in this unit:
    1. Call   print_xywh(Canvas, ... , wpFastPrintInit)
    2. Then call  print_xywh(Canvas, ... , wpFastPrint)   so often as you like
    3. Call   print_xywh(Canvas, ... , wpFastPrintExit)
  You shoul NEVER forget to call wpFastPrintExit !
  The FastPrint Method is much faster wich large Text with lots of pages to print
  because initialisation is only done one time.

  If you have only short Text ore more time
  then you may call print_xywh(Canvas, ... , wpNormalPrint) and you dont have to worry.

  If you want to check if there is enoug space to print all lines you can call
    print_xywh(Canvas, ... , wpPrintCalc). You may do this after wpFastPrintInit, too.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, WPRich, WPWinCtr, WPStatus, WPDefs;

type
  TPrintPreview = class(TForm)
    WPStatusBar1: TWPStatusBar;
    Panel1: TPanel;
    PaintBox1: TPaintBox;
    procedure FormCreate(Sender: TObject);
    procedure WPStatusBar1Update(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure WPStatusBar1Selection(Sender: TObject; index: Integer;
      typ: TWPStatusItemCont; name: String; x, y, w: Integer;
      var Button: TMouseButton; var Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Resize(Sender: TObject);
  private
    { Private-Deklarationen }
    initialized : Boolean; { wpFastPrintInit called ? }
    Zoom    : Integer;
  public
    { Public-Deklarationen }
    last_line,first_line : Longint;
    WordProcessor : TWPRichText;
  end;

var
  PrintPreview: TPrintPreview;

implementation

{$R *.DFM}

procedure TPrintPreview.FormCreate(Sender: TObject);
begin
  WPStatusBar1.SetStringWidthIndex(0,75);
  WPStatusBar1.SetStringWidthIndex(1,75);
  WPStatusBar1.SetStringWidthIndex(1,75);
end;

procedure TPrintPreview.WPStatusBar1Update(Sender: TObject);
begin
  WPStatusBar1.SetStringIndex(0,IntToStr(first_line));
  WPStatusBar1.SetStringIndex(0,'');
  WPStatusBar1.SetStringIndex(0,'');
end;

procedure TPrintPreview.PaintBox1Paint(Sender: TObject);
begin
   if not initialized then                                     { I Use the FastPrintMethod ! }
   begin WordProcessor.Print_xywh(PaintBox1.Canvas,0,0,
              PaintBox1.Width,PaintBox1.Height, first_line,wpFastPrintInit);
         initialized := TRUE;
   end;

   { Set zooming }
   WordProcessor.Zooming := Zoom;

   { Options: pmUsePaper,pmWhiteTransparent,
         pmAllTransparent,pmUseBKColor,pmIgnoreZooming,
         pmUsePageBreaks
     all in unit WPWinCtr. }

   WordProcessor.Print_XYWH_Mode := [pmUsePageBreaks]; 
   last_line := WordProcessor.Print_xywh(PaintBox1.Canvas,0,0,
          PaintBox1.Width,PaintBox1.Height, first_line,wpFastPrint);

   with PaintBox1.Canvas do
   begin
     Pen.Width := 1;
     Pen.Color := clBlack;
     Pen.Style := psDot;
     MoveTo(0,0);
     LineTo(PaintBox1.Width-1,0);
     LineTo(PaintBox1.Width-1,PaintBox1.Height-1);
     LineTo(0,PaintBox1.Height-1);
     LineTo(0,0);
   end;

   { The last FALSE means that output shoud be done, not only calculation }
end;

procedure TPrintPreview.WPStatusBar1Selection(Sender: TObject;
  index: Integer; typ: TWPStatusItemCont; name: String; x, y, w: Integer;
  var Button: TMouseButton; var Shift: TShiftState);
begin
   if index=3 then Close { selected END }
   else if index=2 then   { selected NEXT }
   begin
          first_line := last_line;
          PaintBox1.invalidate;
          WPStatusBar1.SetStringIndex(0,IntToStr(first_line));
   end;
end;

procedure TPrintPreview.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
   if initialized then                                     { Never forget to call Exit !  }
   begin WordProcessor.Zooming := 100;
         WordProcessor.Print_xywh(PaintBox1.Canvas,0,0,
              PaintBox1.Width,PaintBox1.Height, first_line,wpFastPrintExit);
         initialized := TRUE;
   end;
end;

procedure TPrintPreview.Resize(Sender: TObject);
var
  xm, ym : Real;
  papxsiz, papysiz,lmarg,tmarg : Longint;
  x,y,w,h : Integer;
begin
  papxsiz := (WordProcessor.Memo.Header.Layout.paperw *
        Screen.PixelsPerInch) div 1440;
  papysiz := (WordProcessor.Memo.Header.Layout.paperh *
        Screen.PixelsPerInch) div 1440;
  xm := Width / papxsiz;
  ym := (Height-WPStatusBar1.Height-50) /  papysiz;
  if xm < ym then ym := xm;

  w := round(papxsiz * ym);
  H := round(papysiz * ym);

  x := (Width - Panel1.Width) div 2;
  y  := (Height -(WPStatusBar1.Height + h + 10)) div 2;

  Panel1.SetBounds(x,y,w,h);

  lmarg := (WordProcessor.Memo.Header.Layout.margl *
        Screen.PixelsPerInch) div 1440;
  tmarg := (WordProcessor.Memo.Header.Layout.margt *
        Screen.PixelsPerInch) div 1440;

  y := round(tmarg*ym);
  x := round(lmarg*ym);
  lmarg := (WordProcessor.Memo.Header.Layout.margr *
        Screen.PixelsPerInch) div 1440;
  tmarg := (WordProcessor.Memo.Header.Layout.margb *
        Screen.PixelsPerInch) div 1440;

  w :=  w - x - round(lmarg*ym);   { w= Panel1.Width }
  h :=  h - y - round(tmarg*ym);   { h= Panel1.Height }

  PaintBox1.SetBounds(x,y,w,h);

  if not Panel1.Visible then Panel1.Visible:= TRUE;
  Zoom := round(100 * ym);

  WPStatusBar1.SetString(stStatus,IntToStr(Zoom)+'%');
end;

end.
